%% Code to generate Plot 6a
% AoD estimation error vs SNR

clear all
close all
clc

T_s = 1; no_sim = 10^6;
aspread_set = [10; 30; 60];

aspread_doa = aspread_set(1);
file_load =  ['Fig4c_aspread_',num2str(aspread_doa),...
    'T_s_',num2str(T_s),'no_sim',num2str(no_sim),'.mat'];
load(file_load);

figure
semilogy(SNR_dB, (MSE_a_dod_det), 'r--o','LineWidth',1.2)
hold on
semilogy(SNR_dB, (MSE_sd_dod_det), 'b-o','LineWidth',1.2)
hold on

aspread_doa = aspread_set(2);
file_load =  ['Fig4c_aspread_',num2str(aspread_doa),...
    'T_s_',num2str(T_s),'no_sim',num2str(no_sim),'.mat'];
load(file_load);

semilogy(SNR_dB, (MSE_a_dod_det), 'r--*','LineWidth',1.2)
hold on
semilogy(SNR_dB, (MSE_sd_dod_det), 'b-*','LineWidth',1.2)
hold on

aspread_doa = aspread_set(3);
file_load =  ['Fig4c_aspread_',num2str(aspread_doa),...
    'T_s_',num2str(T_s),'no_sim',num2str(no_sim),'.mat'];
load(file_load);

semilogy(SNR_dB, (MSE_a_dod_det), 'r--s','LineWidth',1.2)
hold on
semilogy(SNR_dB, (MSE_sd_dod_det), 'b-s','LineWidth',1.2)
hold on
legend('UQ - 10^{0}','SD - 10^{0}', 'UQ - 30^{0}','SD - 30^{0}', 'UQ - 60^{0}','SD - 60^{0}');
xlabel('SNR (dB)')
ylabel('AoD estimation error (E_{\phi})')
grid on
ylim([10^(-4) 1.1])
xlim([-15 15])

savefig('Fig4c.fig')
saveas(gcf,'Fig4c','epsc')
